/**
This program creates a short, formatted table for converting kilograms to pounds.
*/

public class Table {

   public static void main(String[] args) {
      // Let's set up our column headings. We'll use the format() method to line up the
      // column heading exactly where we want them. "1s" in this case just means we want
      // to end the first column as far to the left as possible. Technically, it can't
      // end that far to the left, but that's okay; it'll just print out from there and
      // end where it ends. The next bit, "10s" is more important. That indicates that
      // we want the next column to end 10 spaces to the right from where the first column
      // ends. Try chaning this value to see how that affects the alignment of the columns.
      System.out.format("%1s%10s", "Kilograms", "Pounds");
      // We'll use println() to drop down to the next line.
      System.out.println();
      // Let's initialize a variable for kilograms as a double, or floating point number.
      double kg = 1.0;
      // Loop goes here
      for (int i = 0; i < 5; i++) {
         // We'll use the format() method again to line up the values under their respective
         // columns. For the first value, 1 indicates that we want the column to end as far
         // to the left as possible, as before. Again, it can't actually end that far to the
         // left, so it'll just end where it ends. Next, ".2f" indicates that the number is a
         // floating point value with 2 decimal places. After that, 15 indicates that we want
         // the next value to end 15 spaces to the right of where the first value ends, and
         // ".2f" again means the value is a floating point number with 2 decimal places.
         System.out.format("%1.2f%15.2f", kg, kg*2.20462);
         // Again, we'll use println() to drop down to the next line.
         System.out.println();
         // We'll increment kg before continuing.
         kg++;
      }
   }
}