/**
This program demonstrates the use of for loops to iterate through arrays.
*/

public class Planets {

   public static void main(String[] args) {
   
      // Let's create an array and populate it with planets.
      String planets[] = {"Mercury", "Venus", "Earth", "Mars", "Jupiter", "Saturn", "Uranus", "Neptune", "Pluto"};
      // We'll need an index value to iterate through the array later.
      int planetIndex = 0;
      // Let's also create a counter to count planets with later.
      int count = 0;
      // We'll need a string variable to store the current planet from the array for analysis.
      String tempPlanet;
      // We can use a for loop to iterate through the array one planet at a time.
      for (int i = 0; i < planets.length; i++) {
         // We'll store the current planet in the variable we created earlier.
         tempPlanet = planets[i];
         // If the planet's name contains exactly 5 letters...
         if (tempPlanet.length() == 5) {
            // increase the count by 1.
            // Notice how we use the ++ operater to add 1 to the count and store it again?
            // What is another way that we could increase the count by 1?
            count++;
         }
      }
      // Since we have a total count now, let's tell the user how many planets have 5 letters in their name.
      System.out.println("There are " + count + " planets with 5 letters in their names.");
      // Now we'll create a new array to store each planet that has 5 letters in its name.
      String[] special = new String[count];
      // This for loop should look familiar. We'll use the same technique to iterate through the array a second time.
      for (int i = 0; i < planets.length; i++) {
         // Again, we'll store the current planet in the variable we created earlier.
         tempPlanet = planets[i];
         // This time, if the planet has exactly 5 letters in its name...
         if (tempPlanet.length() == 5) {
            // we'll add it to the new array.
            special[planetIndex] = tempPlanet;
            // Don't forget to increment the index value so we don't overwrite any planets1
            planetIndex++;
         }
      }
      // We can use the following, simplified approach to iterate through the new array...
      for (String planet : special) {
         // and print out each planet that has exactly 5 letters in its name.
         System.out.println(planet);
      }
   }
}