/**
This program determines the day of the week for any date provided by the user.
When run, the program will ask the user to enter the year, month, and date. It
will then calculate the day of the week and print the result.

Concepts demonstrated here are the use of variables, getting input from the user,
"if/else" logic, and switch/case statements.
**/

import java.util.Scanner;

public class DayOfWeek {

   public static void main(String[] args) {
   
      // Declare variables for year, day of week, day of month, month, year/100, and year of century
      int year, day_of_week, day_of_month, month, year_div_100, year_of_century;
      
      // Set up Scanner object for user input
      Scanner input = new Scanner(System.in);
      
      // Get year, month, and date from user
      System.out.print("Enter a year: ");
      year = input.nextInt();
      System.out.print("Enter a month: ");
      month = input.nextInt();
      System.out.print("Enter a date (day in month): ");
      day_of_month = input.nextInt();
      
      // January and February are treated as the 13th or 14th month of the previous year
      if (month == 1) {
         month = 13;
         year = year - 1;
      }
      else if (month == 2) {
         month = 14;
         year = year - 1;
      }
      
      // Calculate year divided by 100 and year of century
      year_div_100 = year / 100;
      year_of_century = year % 100;
      
      // Calculate the day of the week
      day_of_week = (day_of_month + 26 * (month + 1) / 10 + year_of_century + year_of_century / 4 + year_div_100 / 4 + 5 * year_div_100) % 7;
      
      // Print out the correct day based on the value of day_of_week
      switch (day_of_week) {
         case 0:
            System.out.println("Saturday");
            break;
         case 1:
            System.out.println("Sunday");
            break;
         case 2:
            System.out.println("Monday");
            break;
         case 3:
            System.out.println("Tuesday");
            break;
         case 4:
            System.out.println("Wednesday");
            break;
         case 5:
            System.out.println("Thursday");
            break;
         case 6:
            System.out.println("Friday");
            break;
      }
   
   }

}